///////////////////////////////////////////////////////////////////////////////
// BLUEBOX DemoDlg.cpp : implementation file

#include "stdafx.h"
#include "BLUEBOXLib.h"
#include "BLUEBOX Demo.h"
#include "BLUEBOX DemoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

static	BLUEBOX_Handle handle;

///////////////////////////////////////////////////////////////////////////////
// CBLUEBOXDemoDlg dialog

CBLUEBOXDemoDlg::CBLUEBOXDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBLUEBOXDemoDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CBLUEBOXDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_INTERFACE_COMBO, m_Interface);
	DDX_Control(pDX, IDC_SETTINGS_EDIT, m_Settings);
	DDX_Control(pDX, IDC_CONNECT_BUTTON, m_Connect);
	DDX_Control(pDX, IDC_DISCONNECT_BUTTON, m_Disconnect);
	DDX_Control(pDX, IDC_LOG_EDIT, m_Log);
	DDX_Control(pDX, IDC_DATA_REQUEST_BUTTON, m_DataRequest);
	DDX_Control(pDX, IDC_READ_ID_Q5_BUTTON, m_ReadIdQ5);
	DDX_Control(pDX, IDC_READ_ID_HITAG_S_BUTTON, m_ReadIdHITAGS);
	DDX_Control(pDX, IDC_INVENTORY_ISO15693_BUTTON, m_InventoryISO15693);
	DDX_Control(pDX, IDC_INVENTORY_ISO14443A_BUTTON, m_InventoryISO14443A);
	DDX_Control(pDX, IDC_INVENTORY_ISO18K6C_BUTTON, m_InventoryISO18K6C);
}

BEGIN_MESSAGE_MAP(CBLUEBOXDemoDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_CONNECT_BUTTON, &CBLUEBOXDemoDlg::OnBnClickedConnectButton)
	ON_BN_CLICKED(IDC_DISCONNECT_BUTTON, &CBLUEBOXDemoDlg::OnBnClickedDisconnectButton)
	ON_BN_CLICKED(IDC_DATA_REQUEST_BUTTON, &CBLUEBOXDemoDlg::OnBnClickedDataRequestButton)
	ON_BN_CLICKED(IDC_READ_ID_Q5_BUTTON, &CBLUEBOXDemoDlg::OnBnClickedReadIdQ5Button)
	ON_BN_CLICKED(IDC_READ_ID_HITAG_S_BUTTON, &CBLUEBOXDemoDlg::OnBnClickedReadIdHitagSButton)
	ON_BN_CLICKED(IDC_INVENTORY_ISO15693_BUTTON, &CBLUEBOXDemoDlg::OnBnClickedInventoryIso15693Button)
	ON_BN_CLICKED(IDC_INVENTORY_ISO14443A_BUTTON, &CBLUEBOXDemoDlg::OnBnClickedInventoryIso14443aButton)
	ON_BN_CLICKED(IDC_INVENTORY_ISO18K6C_BUTTON, &CBLUEBOXDemoDlg::OnBnClickedInventoryIso18k6cButton)
END_MESSAGE_MAP()


char CBLUEBOXDemoDlg::HexToAscii (char ch)
{
	char chRetval;

	switch (ch & 0xF)
	{
	case 0:
	case 1:
	case 2:
	case 3:
	case 4:
	case 5:
	case 6:
	case 7:
	case 8:
	case 9:
		chRetval = ch + '0';
		break;
	default:
		chRetval = ch - 0xa + 'A';
	}

	return chRetval;
}


// CBLUEBOXDemoDlg message handlers

BOOL CBLUEBOXDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// Init the library.
	BLUEBOX_ErrorCodes err = BLUEBOX_Init (&handle);
	// Set the address.
	if (err != BLUEBOX_StatusOk)
	{
		return FALSE;
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CBLUEBOXDemoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	CDialog::OnSysCommand(nID, lParam);
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CBLUEBOXDemoDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CBLUEBOXDemoDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CBLUEBOXDemoDlg::OnBnClickedConnectButton()
{	
	int index = m_Interface.GetCurSel();
	char szSettings [64];
	char szChannel [64];
	char szFwRel [64];
	char szTitle [64];
	BYTE bParameters [7];

	// Init Fw rel.
	memset (szFwRel, '\0', sizeof (szFwRel));
	// Init title.
	strcpy (szTitle, "BLUEBOX Demo");

	if (index < 0)
	{
		// No interface selected.
		this->MessageBox("Select the interface (RS232, RS485, TCP) to use!", "BLUEBOX Demo", MB_OK | MB_ICONERROR);
	}
	else
	{
		// Check the settings and prepare the settings string.
		m_Settings.GetWindowText(szSettings, sizeof (szSettings));

		switch (index)
		{
		case 0:
			// RS232
			strcat (szSettings, ",19200,8,n,1,5,60000");
			strcpy (szChannel, "RS232");
			break;
		case 1:
			// RS485
			strcat (szSettings, ",19200,8,n,1,5,60000");
			strcpy (szChannel, "RS485");
			break;

		case 2:
			// TCP
			strcat (szSettings, ":3000,60000");
			strcpy (szChannel, "TCP");
			break;

		default:
			this->MessageBox("Select the interface (RS232, RS485, TCP) to use!", "BLUEBOX Demo", MB_OK | MB_ICONERROR);
			break;
		}

		BLUEBOX_ErrorCodes err = BLUEBOX_SetAddress (&handle, 255);
		// Set the channel.
		if (err == BLUEBOX_StatusOk)
		{
			err = BLUEBOX_SetChannel (&handle, szChannel, szSettings);
		}
		// Open the connection.
		if (err == BLUEBOX_StatusOk)
		{
			err = BLUEBOX_Open (&handle);
		}
		// Get the firmware version.
		if (err == BLUEBOX_StatusOk)
		{
			err = BLUEBOX_GetFwRelease (&handle, BLUEBOX_PRIMARY_READER, szFwRel);

			if (err == BLUEBOX_StatusOk)
			{
				// Prepare the title to print.
				strcat (szTitle, " '");
				strcat (szTitle, szFwRel);
				strcat (szTitle, "'");
				// Print the new title.
				this->SetWindowTextA(szTitle);
			}
			else
			{
				BLUEBOX_Close (&handle);
			}
		}

		// Read parameters.
		if (err == BLUEBOX_StatusOk)
		{
			err = BLUEBOX_ReadParameters (&handle, bParameters);

			if (err == BLUEBOX_StatusOk)
			{
				// Disable the connect button and enable other buttons.
				GetDlgItem(IDC_CONNECT_BUTTON)->EnableWindow(FALSE);
				GetDlgItem(IDC_DISCONNECT_BUTTON)->EnableWindow(TRUE);
				GetDlgItem(IDC_DATA_REQUEST_BUTTON)->EnableWindow(TRUE);
				
				GetDlgItem(IDC_READ_ID_Q5_BUTTON)->EnableWindow(TRUE);
				GetDlgItem(IDC_READ_ID_HITAG_S_BUTTON)->EnableWindow(TRUE);
				GetDlgItem(IDC_INVENTORY_ISO15693_BUTTON)->EnableWindow(TRUE);
				GetDlgItem(IDC_INVENTORY_ISO14443A_BUTTON)->EnableWindow(TRUE);
				GetDlgItem(IDC_INVENTORY_ISO18K6C_BUTTON)->EnableWindow(TRUE);
			}
			else
			{
				BLUEBOX_Close (&handle);
			}
		}

		if (err != BLUEBOX_StatusOk)
		{
			// In case of error.
			strcpy (szTitle, "BLUEBOX Demo");
			this->SetWindowTextA(szTitle);
		}
	}
}

void CBLUEBOXDemoDlg::OnBnClickedDisconnectButton()
{
	char szTitle [64];

	// Close the communication.
	BLUEBOX_ErrorCodes err = BLUEBOX_Close(&handle);
	// Enable the connect button and disable other buttons.
	GetDlgItem(IDC_CONNECT_BUTTON)->EnableWindow(TRUE);
	GetDlgItem(IDC_DISCONNECT_BUTTON)->EnableWindow(FALSE);
	GetDlgItem(IDC_DATA_REQUEST_BUTTON)->EnableWindow(FALSE);
	GetDlgItem(IDC_READ_ID_Q5_BUTTON)->EnableWindow(FALSE);
	GetDlgItem(IDC_READ_ID_HITAG_S_BUTTON)->EnableWindow(FALSE);
	GetDlgItem(IDC_INVENTORY_ISO15693_BUTTON)->EnableWindow(FALSE);
	GetDlgItem(IDC_INVENTORY_ISO14443A_BUTTON)->EnableWindow(FALSE);
	GetDlgItem(IDC_INVENTORY_ISO18K6C_BUTTON)->EnableWindow(FALSE);

	strcpy (szTitle, "BLUEBOX Demo");
	this->SetWindowTextA(szTitle);
}

void CBLUEBOXDemoDlg::OnBnClickedDataRequestButton()
{
	BLUEBOX_Tag *tags;
	int tags_no = 0;

	CString szLog, szPrev;

	// Data Request.
	BLUEBOX_ErrorCodes err = BLUEBOX_DataRequest(&handle, &tags, &tags_no);

	if (err == BLUEBOX_StatusOk)
	{
		for (int index = 0; index < tags_no; index++)
		{
			switch ((*(tags + index)).TagType)
			{
			case BLUEBOX_UNDEFINED:
				szLog = "UNDEFINED";
				break;
			case BLUEBOX_SHORT:
				szLog = "BLUEBOX SHORT";
				break;
			case BLUEBOX_MEDIUM:
				szLog = "BLUEBOX MEDIUM";
				break;
			case BLUEBOX_LARGE:
				szLog = "BLUEBOX LARGE";
				break;
			case BLUEBOX_ISO15693:
				szLog = "ISO 15693";
				break;
			case BLUEBOX_ICODE2:
				szLog = "NXP ICODE SLI";
				break;
			case BLUEBOX_ICODE_SLI_S:
				szLog = "NXP ICODE SLI-S";
				break;
			case BLUEBOX_TAG_IT_HF_I:
				szLog = "TI Tag-It HF-I";
				break;
			case BLUEBOX_EM4035:
				szLog = "EM EM4035";
				break;
			case BLUEBOX_LRI_64_512:
				szLog = "ST LRI 64/512";
				break;
			case BLUEBOX_MB89R118:
				szLog = "Fujitsu MB89R118";
				break;
			case BLUEBOX_MIFARE_1k:
				szLog = "NXP MIFARE 1k";
				break;
			case BLUEBOX_MIFARE_4k:
				szLog = "NXP MIFARE 4k";
				break;
			case BLUEBOX_MIFARE_UL:
				szLog = "NXP MIFARE Ultralight";
				break;
			case BLUEBOX_MIFARE_MINI:
				szLog = "NXP MIFARE Mini";
				break;
			case BLUEBOX_JCOP31:
				szLog = "IBM JCOP31";
				break;
			case BLUEBOX_JCOP:
				szLog = "IBM JCOP";
				break;
			case BLUEBOX_JCOP41:
				szLog = "IBM JCOP41";
				break;
			case BLUEBOX_SR176:
				szLog = "ST SR176";
				break;
			case BLUEBOX_PICOPASS:
				szLog = "PICOPASS";
				break;
			case BLUEBOX_ISO18K6C:
				szLog = "ISO 18000-6C";
				break;
			}

			switch ((*(tags + index)).Antenna)
			{
			case BLUEBOX_NOANT:
				szLog += ", NOANT";
				break;
			case BLUEBOX_ANT_1:
				szLog += ", ANT 1";
				break;
			case BLUEBOX_ANT_2:
				szLog += ", ANT 2";
				break;
			}

			szLog += ", ID = ";
			szLog += HexToAscii(((*(tags + index)).Id [0] & 0xF0) >> 4);
			szLog += HexToAscii((*(tags + index)).Id [0] & 0x0F);

			for (int id = 1; id < (*(tags + index)).Length; id++)
			{
				szLog += "-";
				szLog += HexToAscii(((*(tags + index)).Id [id] & 0xF0) >> 4);
				szLog += HexToAscii((*(tags + index)).Id [id] & 0x0F);
			}

			szLog += "\r\n";

			// Set the text.
			m_Log.GetWindowTextA(szPrev);
			m_Log.SetWindowTextA(szPrev + szLog);
		}

		BLUEBOX_FreeTagsMemory(&handle, &tags, tags_no);
	}
}

void CBLUEBOXDemoDlg::OnBnClickedReadIdQ5Button()
{
	BLUEBOX_TagType type;
	BYTE data [BLUEBOX_Q5_ID_SIZE];
	CString szLog, szPrev;

	// Read the ID.
	BLUEBOX_ErrorCodes err = BLUEBOX_ReadID_Q5 (&handle, BLUEBOX_ANT_1, &type, &data);

	if (err == BLUEBOX_StatusOk)
	{
		// Q5.
		szLog = "Q5";

		szLog += ", ID = ";
		szLog += HexToAscii ((data [0] & 0xF0) >> 4);
		szLog += HexToAscii (data [0] & 0x0F);

		for (int id = 1; id < BLUEBOX_Q5_ID_SIZE; id++)
		{
			szLog += "-";
			szLog += HexToAscii ((data [id] & 0xF0) >> 4);
			szLog += HexToAscii (data [id] & 0x0F);
		}

		szLog += "\r\n";

		// Set the text.
		m_Log.GetWindowTextA(szPrev);
		m_Log.SetWindowTextA(szPrev + szLog);
	}
}

void CBLUEBOXDemoDlg::OnBnClickedReadIdHitagSButton()
{
	BLUEBOX_TagType type;
	BYTE data [BLUEBOX_HITAGS_ID_SIZE];
	CString szLog, szPrev;

	// Read the ID.
	BLUEBOX_ErrorCodes err = BLUEBOX_ReadID_HITAGS (&handle, BLUEBOX_ANT_1, &type, &data);

	if (err == BLUEBOX_StatusOk)
	{
		// HITAG S.
		szLog = "HITAG S";

		szLog += ", ID = ";
		szLog += HexToAscii ((data [0] & 0xF0) >> 4);
		szLog += HexToAscii (data [0] & 0x0F);

		for (int id = 1; id < BLUEBOX_Q5_ID_SIZE; id++)
		{
			szLog += "-";
			szLog += HexToAscii ((data [id] & 0xF0) >> 4);
			szLog += HexToAscii (data [id] & 0x0F);
		}

		szLog += "\r\n";

		// Set the text.
		m_Log.GetWindowTextA(szPrev);
		m_Log.SetWindowTextA(szPrev + szLog);
	}
}

void CBLUEBOXDemoDlg::OnBnClickedInventoryIso15693Button()
{
	BLUEBOX_Tag *tags;
	int tags_no = 0;

	CString szLog, szPrev;

	// Inventory.
	BLUEBOX_ErrorCodes err = BLUEBOX_Inventory_ISO15693 (&handle, BLUEBOX_ANT_1, 0, 0, &tags, &tags_no);

	if (err == BLUEBOX_StatusOk)
	{
		for (int index = 0; index < tags_no; index++)
		{
			switch ((*(tags + index)).TagType)
			{
			case BLUEBOX_ISO15693:
				szLog = "ISO 15693";
				break;
			case BLUEBOX_ICODE2:
				szLog = "NXP ICODE SLI";
				break;
			case BLUEBOX_ICODE_SLI_S:
				szLog = "NXP ICODE SLI-S";
				break;
			case BLUEBOX_TAG_IT_HF_I:
				szLog = "TI Tag-It HF-I";
				break;
			case BLUEBOX_EM4035:
				szLog = "EM EM4035";
				break;
			case BLUEBOX_LRI_64_512:
				szLog = "ST LRI 64/512";
				break;
			case BLUEBOX_MB89R118:
				szLog = "Fujitsu MB89R118";
				break;
			}

			switch ((*(tags + index)).Antenna)
			{
			case BLUEBOX_NOANT:
				szLog += ", NOANT";
				break;
			case BLUEBOX_ANT_1:
				szLog += ", ANT 1";
				break;
			}

			szLog += ", ID = ";
			szLog += HexToAscii(((*(tags + index)).Id [0] & 0xF0) >> 4);
			szLog += HexToAscii((*(tags + index)).Id [0] & 0x0F);

			for (int id = 1; id < (*(tags + index)).Length; id++)
			{
				szLog += "-";
				szLog += HexToAscii(((*(tags + index)).Id [id] & 0xF0) >> 4);
				szLog += HexToAscii((*(tags + index)).Id [id] & 0x0F);
			}

			szLog += "\r\n";

			// Set the text.
			m_Log.GetWindowTextA(szPrev);
			m_Log.SetWindowTextA(szPrev + szLog);
		}

		BLUEBOX_FreeTagsMemory(&handle, &tags, tags_no);
	}
}

void CBLUEBOXDemoDlg::OnBnClickedInventoryIso14443aButton()
{
	BLUEBOX_Tag *tags;
	int tags_no = 0;

	CString szLog, szPrev;

	// Inventory.
	BLUEBOX_ErrorCodes err = BLUEBOX_Inventory_ISO14443A (&handle, BLUEBOX_ANT_1, &tags, &tags_no);

	if (err == BLUEBOX_StatusOk)
	{
		for (int index = 0; index < tags_no; index++)
		{
			switch ((*(tags + index)).TagType)
			{
			case BLUEBOX_MIFARE_1k:
				szLog = "NXP MIFARE 1k";
				break;
			case BLUEBOX_MIFARE_4k:
				szLog = "NXP MIFARE 4k";
				break;
			case BLUEBOX_MIFARE_UL:
				szLog = "NXP MIFARE Ultralight";
				break;
			case BLUEBOX_MIFARE_MINI:
				szLog = "NXP MIFARE Mini";
				break;
			case BLUEBOX_JCOP31:
				szLog = "IBM JCOP31";
				break;
			case BLUEBOX_JCOP:
				szLog = "IBM JCOP";
				break;
			case BLUEBOX_JCOP41:
				szLog = "IBM JCOP41";
				break;
			}

			switch ((*(tags + index)).Antenna)
			{
			case BLUEBOX_NOANT:
				szLog += ", NOANT";
				break;
			case BLUEBOX_ANT_1:
				szLog += ", ANT 1";
				break;
			case BLUEBOX_ANT_2:
				szLog += ", ANT 2";
				break;
			}

			szLog += ", ID = ";
			szLog += HexToAscii(((*(tags + index)).Id [0] & 0xF0) >> 4);
			szLog += HexToAscii((*(tags + index)).Id [0] & 0x0F);

			for (int id = 1; id < (*(tags + index)).Length; id++)
			{
				szLog += "-";
				szLog += HexToAscii(((*(tags + index)).Id [id] & 0xF0) >> 4);
				szLog += HexToAscii((*(tags + index)).Id [id] & 0x0F);
			}

			szLog += "\r\n";

			// Set the text.
			m_Log.GetWindowTextA(szPrev);
			m_Log.SetWindowTextA(szPrev + szLog);
		}

		BLUEBOX_FreeTagsMemory(&handle, &tags, tags_no);
	}
}

void CBLUEBOXDemoDlg::OnBnClickedInventoryIso18k6cButton()
{
	BLUEBOX_Tag *tags;
	int tags_no = 0;

	CString szLog, szPrev;

	// Inventory.
	BLUEBOX_ErrorCodes err = BLUEBOX_Inventory_ISO18K6C (&handle, &tags, &tags_no);

	if (err == BLUEBOX_StatusOk)
	{
		for (int index = 0; index < tags_no; index++)
		{
			switch ((*(tags + index)).TagType)
			{
			case BLUEBOX_UNDEFINED:
				szLog = "UNDEFINED";
				break;
			case BLUEBOX_ISO18K6C:
				szLog = "ISO 18000-6C";
				break;
			}

			switch ((*(tags + index)).Antenna)
			{
			case BLUEBOX_NOANT:
				szLog += ", NOANT";
				break;
			case BLUEBOX_ANT_1:
				szLog += ", ANT 1";
				break;
			case BLUEBOX_ANT_2:
				szLog += ", ANT 2";
				break;
			case BLUEBOX_ANT_3:
				szLog += ", ANT 3";
				break;
			case BLUEBOX_ANT_4:
				szLog += ", ANT 4";
				break;
			}

			szLog += ", ID = ";
			szLog += HexToAscii(((*(tags + index)).Id [0] & 0xF0) >> 4);
			szLog += HexToAscii((*(tags + index)).Id [0] & 0x0F);

			for (int id = 1; id < (*(tags + index)).Length; id++)
			{
				szLog += "-";
				szLog += HexToAscii(((*(tags + index)).Id [id] & 0xF0) >> 4);
				szLog += HexToAscii((*(tags + index)).Id [id] & 0x0F);
			}

			szLog += "\r\n";

			// Set the text.
			m_Log.GetWindowTextA(szPrev);
			m_Log.SetWindowTextA(szPrev + szLog);
		}

		BLUEBOX_FreeTagsMemory(&handle, &tags, tags_no);
	}
}
